//
//  BPURLDownloader.h
//  FileDownloader
//
//  Created by Alykhan Jetha on 10-05-06.
//  Copyright 2010 Marketcircle, Inc. All rights reserved.
//

#import "BPURLMessage.h"

@class BIURLReference;

/*!
 We don't use NSURLDownload because it refuses to connect to our server because the server has a self signed certificate.
 */
@interface BPURLDownloader : BPURLMessage {
	
	NSUInteger bytesReceived;
	NSUInteger expectedBytes;
	BOOL progressIsDeterminate;
		
	NSMutableData *bytes;
	NSURL *localDestination;
	
	BIURLReference *urlReference;
	
	NSString *expectedMIMEType;
	NSString *receivedMIMEType;
	
}

@property (retain) NSMutableData *bytes;
@property (retain) NSURL *localDestination;
@property (retain) BIURLReference *urlReference;
@property (retain) NSString *expectedMIMEType;
@property (retain) NSString *receivedMIMEType;

@property (assign) NSUInteger bytesReceived;
@property (assign) NSUInteger expectedBytes;
@property (assign) BOOL progressIsDeterminate;


- (id)initForURL:(NSString *)aURLStr
	urlReference:(BIURLReference *)aReference
localDestination:(NSString *)local
expectedMIMEType:(NSString *)expMT
		username:(NSString *)aUsername 
		password:(NSString *)aPassword
		delegate:(id)aDeleg;

@end

@interface NSObject (BPURLDownloaderDelegate)
- (void)downloader:(BPURLDownloader *)downloader failedWithError:(NSError *)anError;
- (void)downloaderDidFinish:(BPURLDownloader *)downloader;
@end